/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals;

import emulator.hardware.io.peripherals.VicTapeTrack;
import java.util.LinkedList;

public class VicTapeContents {
    private LinkedList<VicTapeTrack> track_list = new LinkedList();
    private int current_index = 0;

    public VicTapeTrack getCurrentTrack() {
        if (this.current_index < this.track_list.size()) {
            return this.track_list.get(this.current_index);
        }
        return new VicTapeTrack();
    }

    public void addTrack(VicTapeTrack track) {
        long counter = 0L;
        while (counter < track.getCount() && this.current_index < this.track_list.size()) {
            counter += this.track_list.get(this.current_index).getCount();
            this.track_list.remove(this.current_index);
        }
        this.track_list.add(this.current_index, track);
        ++this.current_index;
    }

    public int getCurrentIndex() {
        return this.current_index;
    }

    public int getTrackCount() {
        return this.track_list.size();
    }

    public void rewind() {
        if (this.current_index > 0) {
            --this.current_index;
        }
    }

    public void forward() {
        if (this.current_index < this.track_list.size()) {
            ++this.current_index;
        }
    }
}

